#ifndef __SPI_H
#define __SPI_H

/* 

	Memory Card System Suitable for PIC18 devices,  
	modified by Mauro Grassi 2010, from the original, 
	by Mauro Grassi, 2009.
		
*/

#include "GenericTypeDefs.h"
#include "gps.h"
#include "hardwarestate.h"

#define USE_SD_DMA		0
#define USE_PIC18_DMA	1

#define SD_SDI_RPn		18
#define SD_SDI_RAM2RAM	4

#define SPI_SPEED	 	0x1E

#define SDCS			(LATBbits.LATB2)
#define SDCS_TRIS		(TRISBbits.TRISB2)

#define SDSENSE			(PORTBbits.RB3)
#define	SDSENSE_ON		0
#define SDSENSE_TRIS	(TRISBbits.TRISB3)
#define SDSENSEPULLUPS	(INTCON2bits.RBPU)
	
#define SDPOWER			(LATCbits.LATC2)
#define SDPOWER_TRIS	(TRISCbits.TRISC2)

void 					InitSPI(int speed);
unsigned char 			WriteSPI(unsigned char x);
unsigned char 			WriteSPIWithoutSS(unsigned char x);
extern unsigned char	SPIBigBuffer[512];
extern unsigned char 	SPISmallBuffer[1];
extern unsigned char 	SPI18BigBuffer[512];
extern unsigned char 	SPI18SmallBuffer[1];
unsigned char* 			BulkReadPIC18SPI(unsigned char*, unsigned short); 
unsigned char* 			BulkWritePIC18SPI(unsigned char*, unsigned short); 
void 					setPWMDuty(unsigned int x);
void 					setMemoryCardPower(int onoff);
void 					closeSPI(void);
void					memoryCardTask(void);
void 					powerSwitchComparator(unsigned char on, unsigned char edge);
void 					initSPIState(SPI_DESCRIPTOR* sd);
void 					closeSPIState(SPI_DESCRIPTOR* sd);
unsigned char 			WriteSPIState(SPI_DESCRIPTOR* sd, unsigned char x);
void 					ejectCard(void);
void 					memoryCardEmptyPowerSaverTask(void);
void					reconnectMemoryCard(void);

#endif
